﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Enumerations
{
    // Listing 3-52
    public enum PorridgeTemperature
    {
        TooHot,
        TooCold,
        JustRight
    }

    // Listing 3-54
    [System.Flags]
    public enum Ingredients
    {
        Eggs = 1,
        Bacon = 2,
        Sausages = 4,
        Mushrooms = 8,
        Tomato = 0x10,
        BlackPudding = 0x20,
        BakedBeans = 0x40,
        TheFullEnglish = 0x7f
    }


    // Listing 3-55
    [System.Flags]
    public enum TooManyChoices : long
    {
        Foo = 0x100000000
    } 

    class Program
    {
        static void Main(string[] args)
        {
            var porridge = new Porridge { Temperature = PorridgeTemperature.TooHot };

            // Listing 3-53
            switch (porridge.Temperature)
            {
                case PorridgeTemperature.TooHot:
                    GoOutsideForABit();
                    break;

                case PorridgeTemperature.TooCold:
                    MicrowaveMyBreakfast();
                    break;

                case PorridgeTemperature.JustRight:
                    NomNomNom();
                    break;
            }
        }

        public static void Unreadable()
        {
            var stream = new MemoryStream();
            // Listing 3-56
            var rdr = new StreamReader(stream, true); 
        }


        public static void MoreReadable()
        {
            string path = @"c:\temp\log.txt";

            // Listing 3-57
            var fs = new FileStream(path, FileMode.Append); 
        }

        private static void NomNomNom()
        {
            Console.WriteLine("Mniam!");
        }

        private static void MicrowaveMyBreakfast()
        {
            Console.WriteLine("Jestem głodny.");
        }

        private static void GoOutsideForABit()
        {
            Console.WriteLine("Jestem głodny i jest mi zimno.");
        }
    }

    public class Porridge
    {
        public PorridgeTemperature Temperature { get; set; }
    }
}
